/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.kubejs.bindings.TextWrapper;
import dev.latvian.mods.kubejs.client.NotificationToast;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;

public class NotificationBuilder {
    public static final class_2561[] NO_TEXT = new class_2561[0];
    public static final Duration DEFAULT_DURATION = Duration.ofSeconds(5L);
    public static final Color DEFAULT_BORDER_COLOR = new SimpleColor(4663636);
    public static final Color DEFAULT_BACKGROUND_COLOR = new SimpleColor(2364213);
    private static final int FLAG_ICON = 1;
    private static final int FLAG_TEXT_SHADOW = 2;
    private static final int FLAG_DURATION = 4;
    public Duration duration;
    public class_2561 text;
    public transient int iconType;
    public transient String icon;
    public int iconSize;
    public Color outlineColor;
    public Color borderColor;
    public Color backgroundColor;
    public boolean textShadow;

    public static NotificationBuilder of(Context cx, Object object) {
        if (object instanceof NotificationBuilder) {
            NotificationBuilder b = (NotificationBuilder)object;
            return b;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return null;
        }
        if (object instanceof BaseFunction) {
            BaseFunction func = (BaseFunction)object;
            Consumer consumer = (Consumer)NativeJavaObject.createInterfaceAdapter((Context)cx, Consumer.class, (ScriptableObject)func);
            NotificationBuilder b = new NotificationBuilder();
            consumer.accept(b);
            return b;
        }
        NotificationBuilder b = new NotificationBuilder();
        b.text = TextWrapper.of(object);
        return b;
    }

    public static NotificationBuilder make(Consumer<NotificationBuilder> consumer) {
        NotificationBuilder b = new NotificationBuilder();
        consumer.accept(b);
        return b;
    }

    public NotificationBuilder() {
        this.duration = DEFAULT_DURATION;
        this.text = class_2561.method_43473();
        this.iconType = 0;
        this.icon = "";
        this.iconSize = 16;
        this.outlineColor = SimpleColor.BLACK;
        this.borderColor = DEFAULT_BORDER_COLOR;
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.textShadow = true;
    }

    public NotificationBuilder(class_2540 buf) {
        int flags = buf.method_10816();
        this.text = buf.method_10808();
        Duration duration = this.duration = (flags & 4) != 0 ? Duration.ofMillis(buf.method_10792()) : DEFAULT_DURATION;
        if ((flags & 1) != 0) {
            this.iconType = buf.method_10816();
            this.icon = buf.method_19772();
            this.iconSize = buf.readByte();
        } else {
            this.iconType = 0;
            this.icon = "";
            this.iconSize = 16;
        }
        this.outlineColor = UtilsJS.readColor(buf);
        this.borderColor = UtilsJS.readColor(buf);
        this.backgroundColor = UtilsJS.readColor(buf);
        this.textShadow = (flags & 2) != 0;
    }

    public void write(class_2540 buf) {
        int flags = 0;
        if (this.iconType != 0) {
            flags |= 1;
        }
        if (this.textShadow) {
            flags |= 2;
        }
        if (this.duration != DEFAULT_DURATION) {
            flags |= 4;
        }
        buf.method_10804(flags);
        buf.method_10805(this.text);
        if (this.duration != DEFAULT_DURATION) {
            buf.method_10791(this.duration.toMillis());
        }
        if (this.iconType != 0) {
            buf.method_10804(this.iconType);
            buf.method_10814(this.icon);
            buf.writeByte(this.iconSize);
        }
        UtilsJS.writeColor(buf, this.outlineColor);
        UtilsJS.writeColor(buf, this.borderColor);
        UtilsJS.writeColor(buf, this.backgroundColor);
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.iconType = 1;
    }

    public void setItemIcon(class_1799 stack) {
        this.icon = stack.kjs$getId();
        if (stack.method_7947() > 1) {
            this.icon = stack.method_7947() + "x " + this.icon;
        }
        if (stack.method_7969() != null) {
            this.icon = this.icon + " " + stack.method_7969();
        }
        this.iconType = 2;
    }

    public void setAtlasIcon(String icon) {
        this.icon = icon;
        this.iconType = 3;
    }

    @Environment(value=EnvType.CLIENT)
    public void show() {
        class_310 mc = class_310.method_1551();
        mc.method_1566().method_1999((class_368)new NotificationToast(mc, this));
    }
}

